"""Tie kernel builder (unused stub).

In the full present‑act engine, ties between candidates after
lexicographic ordering are resolved by constructing a primitive binary
adjacency matrix over the tied candidates, adding a small multiple of
the identity, and sampling according to the squared Perron–Frobenius
eigenvector.  This stub is provided for completeness but is not
invoked in the simplified Simulation A implementation.
"""

import numpy as np


def build_tie_kernel(num_candidates: int, eta: float = 1e-6) -> np.ndarray:
    """Constructs a primitive binary matrix with the given size.

    Parameters
    ----------
    num_candidates : int
        The number of tied candidates.
    eta : float, default ``1e-6``
        Small regularisation added to the diagonal.

    Returns
    -------
    kernel : ndarray of shape (num_candidates, num_candidates)
        A primitive binary matrix with the regularisation added.
    """
    # For simplicity, return an all‑ones matrix (complete graph) with eta
    kernel = np.ones((num_candidates, num_candidates), dtype=float)
    kernel += eta * np.eye(num_candidates)
    return kernel